EXPORT_PATH=$1
APP_PATH="$EXPORT_PATH/$PRODUCT_NAME.app"
ZIP_PATH="$EXPORT_PATH/$PRODUCT_NAME.zip"
UNNOTARIZED_ZIP_PATH="$EXPORT_PATH/$PRODUCT_NAME.unnotarized.zip"
NOTARIZE_RESULTS="$EXPORT_PATH/notarize_app_results.raw"
NOTARIZE_RESULTS_PLIST="$EXPORT_PATH/notarize_app_results.plist"
CHECK_NOTARIZE="$EXPORT_PATH/check_notarize.raw"
CHECK_NOTARIZE_PLIST="$EXPORT_PATH/check_notarize.plist"

AUTH_KEY="46VL6S3K9C"
AUTH_ISSUER="270362a3-9d5c-405a-a2be-ad63081eb895"


### EXPORT
# Archive and export
echo Archiving
echo running /usr/bin/xcodebuild -exportArchive -archivePath "$ARCHIVE_PATH" -exportOptionsPlist "$SRCROOT/ExportOptions.plist" -exportPath "$EXPORT_PATH"
/usr/bin/xcodebuild -exportArchive -archivePath "$ARCHIVE_PATH" -exportOptionsPlist "$SRCROOT/ExportOptions.plist" -exportPath "$EXPORT_PATH"

# Create a ZIP archive suitable for altool.
echo Zipping
/usr/bin/ditto -c -k --keepParent "$APP_PATH" "$UNNOTARIZED_ZIP_PATH"


### NOTARIZE
# Upload for notarization
UPLOAD_UUID=$(uuidgen)

success=0
for i in 1 2 3 4 5 6; do
    echo "Uploading to Apple for notarization"
    xcrun altool --notarize-app \
        --apiKey $AUTH_KEY \
        --apiIssuer $AUTH_ISSUER \
        --file $UNNOTARIZED_ZIP_PATH \
        --primary-bundle-id "${UPLOAD_UUID}" \
        --output-format xml  \
        > $NOTARIZE_RESULTS

    grep ^.*\<.* $NOTARIZE_RESULTS > $NOTARIZE_RESULTS_PLIST

    echo "Extracting Request UUID"
    NOTARIZE_REQUEST_UUID=$(/usr/libexec/PlistBuddy -c "Print notarization-upload:RequestUUID" $NOTARIZE_RESULTS_PLIST)
    NOTARIZE_REQUEST_MESSAGE=$(/usr/libexec/PlistBuddy -c "Print success-message" $NOTARIZE_RESULTS_PLIST)
    
    if [[  "${#NOTARIZE_REQUEST_UUID}" -gt "6" ]]; then
        success=1
        break
    else
        echo "Upload notary failed"
        sleep 5
    fi
done

if [ $success -eq 1 ] ; then
    echo "Notary Upload Success: UUID: $NOTARIZE_REQUEST_UUID, Message: $NOTARIZE_REQUEST_MESSAGE"
else
    echo "Timed out, failed to upload notary"
    exit
fi


echo "Periodically Checking Progress"
success=0
for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20; do
    sleep 30
    echo "Checking progress..."
    xcrun altool --notarization-info "${NOTARIZE_REQUEST_UUID}" --apiKey "${AUTH_KEY}" --apiIssuer "${AUTH_ISSUER}" --output-format xml > $CHECK_NOTARIZE
    grep ^.*\<.* $CHECK_NOTARIZE > $CHECK_NOTARIZE_PLIST
    
    NOTARIZATION_STATUS=$(/usr/libexec/PlistBuddy -c "Print notarization-info:Status" $CHECK_NOTARIZE_PLIST)
    NOTARIZATION_STATUS_MESSAGE=$(/usr/libexec/PlistBuddy -c "Print notarization-info:Status Message" $CHECK_NOTARIZE_PLIST)
    echo "Status: $NOTARIZATION_STATUS, Message: $NOTARIZATION_STATUS_MESSAGE"

 
    if [[  "${NOTARIZATION_STATUS}" =~ "Invalid" ]]; then
        echo "Error with notarization. Exiting $NOTARIZATION_STATUS $NOTARIZATION_STATUS_MESSAGE"
        break
    fi
 
    if [[  "${NOTARIZATION_STATUS}" =~ "success" ]]; then
        success=1
        break
    else
        echo "Not completed yet. Sleeping for 30 seconds"
    fi
done

if [ $success -eq 1 ] ; then
    echo "Stapling and running packaging up"
    xcrun stapler staple "${APP_PATH}"
    
    echo "Checking Work: "
    spctl -a -v "$APP_PATH"
    
    echo "Zipping"
    /usr/bin/ditto -c -k --keepParent "$APP_PATH" "$ZIP_PATH"
    
    echo "Signed File"
    echo $APP_PATH
    echo "Signed Zip"
    echo $ZIP_PATH
    
else
    echo "Timed out, failed to notarize"
    exit
fi

